'use strict';
const MANIFEST = 'flutter-app-manifest';
const TEMP = 'flutter-temp-cache';
const CACHE_NAME = 'flutter-app-cache';

const RESOURCES = {"flutter_bootstrap.js": "8e5a819b358961d68aecf3d43b5cde00",
"version.json": "c5fb53b68cc8646b0ec51ec0996e1890",
"index.html": "dc4130bd152daade1c914a0775859ba2",
"/": "dc4130bd152daade1c914a0775859ba2",
"main.dart.js": "dc6c1f9c906237cbf55f552129f21104",
"flutter.js": "888483df48293866f9f41d3d9274a779",
"assetlinks.json": "fa73362249c776ab25e8a51327b872e3",
"favicon.png": "95aacead11a7ec9f7789266e561e78a1",
"icons/Icon-192.webp": "8dc31e4bfc1467b4e2b6e0efd8973fd5",
"icons/Icon-192.png": "81a9b54e0c4e10234b032a2760fb21d0",
"icons/Icon-maskable-192.png": "81a9b54e0c4e10234b032a2760fb21d0",
"icons/favicon.webp": "8dc31e4bfc1467b4e2b6e0efd8973fd5",
"icons/Icon-maskable-512.png": "018002e187026dd9f268a24f53e57858",
"icons/Icon-512.png": "018002e187026dd9f268a24f53e57858",
"manifest.json": "4c51de02d7289c1a7217c3031624950e",
"main.dart.js_1.part.js": "251f20dfb732eb86b050185dd6171396",
"assets/AssetManifest.json": "be81141b3c457b77f11bdf20258cc2db",
"assets/NOTICES": "e25f4fec2a7526eea0fd069d486cda41",
"assets/FontManifest.json": "a34b60b4651c9f5459827d7266ce1f60",
"assets/AssetManifest.bin.json": "a54123ba39296fa1282fa0ca7c2fc4a0",
"assets/packages/cupertino_icons/assets/CupertinoIcons.ttf": "ea8b749e7171aa05dd83edc78917320f",
"assets/packages/flutter_map/lib/assets/flutter_map_logo.png": "208d63cc917af9713fc9572bd5c09362",
"assets/packages/baseflow_plugin_template/assets/poweredByBaseflow.png": "e48c2485c3f7568d987424ec6a0ba677",
"assets/packages/baseflow_plugin_template/assets/logo.png": "1c89131f5118e408eefc3fac5416dabc",
"assets/shaders/ink_sparkle.frag": "ecc85a2e95f5e9f53123dcaf8cb9b6ce",
"assets/AssetManifest.bin": "c2126d5b31135313f337628fb88ce50d",
"assets/fonts/MaterialIcons-Regular.otf": "d98c3fa0a1aed3f04a1c4580968fe8b7",
"assets/assets/styles.css": "daa289f84fff89865e57f05e47c3067c",
"assets/assets/images/logo_transparent.png": "feb980336fd8fe0be25ae96a6cd2788f",
"assets/assets/images/Icon-192.webp": "8dc31e4bfc1467b4e2b6e0efd8973fd5",
"assets/assets/images/process_content.png": "b611beda919a9612f5ddad63da9e3768",
"assets/assets/images/update_image.png": "f569a15c82b1e717e965d4ac33f95050",
"assets/assets/images/advertisement_onboarding.png": "b0b286746dc49d38c468fd6212d09c4c",
"assets/assets/images/spending_onboarding.png": "dc0e967327e72f5313d4f2cebd442992",
"assets/assets/images/support_screen_image.png": "63f9bc60f77a5d50966ed7618d0c3121",
"assets/assets/images/user_login_image.png": "f6ef9ed9ed81e7a53a179004227f92bf",
"assets/assets/images/logo.webp": "8dc31e4bfc1467b4e2b6e0efd8973fd5",
"assets/assets/images/Colleagues%2520celebrating%2520success%2520with%2520high%2520five.png": "3b9c61a4182dddc289a8645b918a0b63",
"assets/assets/images/logout_img.png": "ddc958ad3b8d1a137077a0c9bef7c724",
"assets/assets/images/avatar.png": "55eed0ccffdf7518c0104b74f8f806df",
"assets/assets/images/celebrating_success.png": "70bc40b208e42c81855883a966ebf039",
"assets/assets/images/favicon.webp": "8dc31e4bfc1467b4e2b6e0efd8973fd5",
"assets/assets/images/search_onboarding.png": "fafe3fe7ad9d7bc8750f03aa2524257b",
"assets/assets/images/logo.png": "15ecbf6bc429ec1c5221447007f55379",
"assets/assets/images/vpn_image.png": "609d3f740c68862787f2017450eef950",
"assets/assets/images/Icon-512.webp": "8dc31e4bfc1467b4e2b6e0efd8973fd5",
"assets/assets/images/user_image_otp.png": "6252499658a4f8f8ae6fd427978e11ca",
"assets/assets/images/camera.png": "0f865dc1bda10c73943742b7638dd8c3",
"assets/assets/images/no_internet_connection.png": "4ae6df2bd76e5977cf708be5ebdf1ce9",
"assets/assets/images/error_state.svg": "09f498c50435cc2ada8f4f5582b4c042",
"assets/assets/images/stopBillboardImage.png": "d583004cebb4e39a42a65485689dde03",
"assets/assets/json/blue_loading.json": "4e54a4e48f6ccddfb4483b87d872f2b4",
"assets/assets/json/splash_money.json": "20d31a60867af25f110dd2b9398882fc",
"assets/assets/json/splash.json": "9449e9e4f5c0cdbcf441b7fb3976cea0",
"assets/assets/json/WalletMoneyAdded.json": "74ae4dc0ffd2ef4ddae2b5962982db3f",
"assets/assets/icons/Search.svg": "cfeb486e5070bd4ccd5e7d1ec5b50b09",
"assets/assets/icons/search_bold.svg": "207fabb8bd57734c6ccd3cd79e7acbfb",
"assets/assets/icons/about_us.svg": "2cc170ba4e714b17939b1318588fb4cf",
"assets/assets/icons/mage_filter.svg": "99be37f1ba9d8b6256c39580c90b08e9",
"assets/assets/icons/info_input.svg": "8b8f1e34f40598619013376c85a958c9",
"assets/assets/icons/republish.svg": "b47f47ef0365c7d8b811df4b37561131",
"assets/assets/icons/eye_off.svg": "1eef76e519a8b2cc40e910e2b8ccd457",
"assets/assets/icons/vaadin_money-deposit.svg": "4f39c90e0c2f18b8a1d3c007f3c33b96",
"assets/assets/icons/wallet-outline.svg": "03bb31a08e57613ec89947e662367487",
"assets/assets/icons/support_mail_icon.svg": "5035c8758c3e43322475929cb4070393",
"assets/assets/icons/upload_icon.svg": "cb6b332d79a1d6410af45deced23a99b",
"assets/assets/icons/home_bold.svg": "278cda7c3190f849cca389eb02861a80",
"assets/assets/icons/pin-zoom%2520in.svg": "3061fd678de8792ea80ad3abfe840d21",
"assets/assets/icons/Terms%2520and%2520Conditions.svg": "57ee371b4305bba5ff359da53f7aa327",
"assets/assets/icons/mony_icon.svg": "829f310bf7bf0d466c633cef6cd1b49e",
"assets/assets/icons/tabler_report-analytics.svg": "f231c88fe228ef53a75502d63e106ff1",
"assets/assets/icons/delete_icon.png": "7cebf180474d702d03c5fe4d579cf22f",
"assets/assets/icons/map_bold.svg": "788d9611d3b57605d8ecc39c19bdd1ac",
"assets/assets/icons/minimize.svg": "73e31798229077ea99f2671452bc0624",
"assets/assets/icons/directions_outlined.svg": "2713a78938bd4106346cfb975de81a8b",
"assets/assets/icons/link_out.svg": "66a48fb49aaaa35802fa38f9fe328edd",
"assets/assets/icons/nav.svg": "64467bcf04486e6dc7d4bd06276d9ee4",
"assets/assets/icons/drawal.svg": "5adc96921de5c83b201f9239c6f8d09b",
"assets/assets/icons/arrow_up.svg": "d065097d9c34e11f2af42dc6753b38eb",
"assets/assets/icons/map_outline.svg": "c5369270aa043e0f828520cc2c879122",
"assets/assets/icons/people_icon.svg": "986642c90e5805ce5ccb779410fbff03",
"assets/assets/icons/navEnable.svg": "faa5e8589a8b7ff54cd1945f879a9b48",
"assets/assets/icons/like.png": "61c4f9de2ae4a7d9bec49e75413c50cd",
"assets/assets/icons/cancel-01.svg": "7a32861d81199955392970baec0357b1",
"assets/assets/icons/mdi_hide-outline.svg": "381b290c3ff3f2d979eb244eb293c745",
"assets/assets/icons/gallery_image_icon.svg": "8928430d75100413155801fdbd0bcca5",
"assets/assets/icons/my_neighborhood.png": "7860e7fef5a6a2d0a447df1e0df877d3",
"assets/assets/icons/close_icon.svg": "c48b5f95d99cea007c8b98c3ced405b1",
"assets/assets/icons/arrow_down.svg": "6d6652022deda76593b60a26b5758512",
"assets/assets/icons/plus_icon.svg": "3d56089deffeb5eacffdd4fae29aa9e3",
"assets/assets/icons/iconamoon_edit.svg": "0b5ea69558721c8265210ff759013a22",
"assets/assets/icons/share.png": "61c4f9de2ae4a7d9bec49e75413c50cd",
"assets/assets/icons/check_circle_icon.svg": "a7b6f39cb7f9b9ad69e04703e394298f",
"assets/assets/icons/mdi_billboard.svg": "95ee71f63a93de1cc979b90ee5f64b91",
"assets/assets/icons/exit.svg": "c2437b61a386dcf76b68126107d655b8",
"assets/assets/icons/support_phone_icon.svg": "2e6b23394a31d10d55dad64272b32a0e",
"assets/assets/icons/Phone.svg": "6a88428f103425784592afec7f4a28c8",
"assets/assets/icons/eye.svg": "6ea1452dca1ac9d4b30620ed7bc8c01c",
"assets/assets/icons/location.svg": "c1c5c16e2fe9dfa4d8d808d91096dccd",
"assets/assets/icons/navCenter.svg": "ec9db5173925d1a1b3130771a34b4c15",
"assets/assets/icons/security-safe.svg": "6b21813c577f6740ca90d4d3d4cb0689",
"assets/assets/icons/ep_back.svg": "6883e069451d8cd29a53f1526a0a1b27",
"assets/assets/icons/home_outline.svg": "f184b5efdea8306ac55a8696fbff66d5",
"assets/assets/icons/notifications.svg": "69198c3883d9e84d36ea2a2fdd83bc51",
"assets/assets/icons/camera_image_icon.svg": "04744b81ff810f6c8f8ae076e2f96eeb",
"assets/assets/icons/money_hand.svg": "998de5f4cbb44b8d1aa5a9d16282aa78",
"assets/assets/icons/uil_exchange.svg": "043ad8d83918769b8f4e7cb2d21ad0f9",
"assets/assets/icons/wallet_bold.svg": "b889aa020eeca76d69226f36c4b4a914",
"assets/assets/icons/circule_message.svg": "5a37c7dfe26481ca04cd8189e7ede79e",
"assets/assets/icons/alt_arrow_left_outline.svg": "8b4b41e04f18e9063b37c185fb61b022",
"assets/assets/fonts/IRANSans_Bold.ttf": "da941c58b16727d4339a8c92c46f2704",
"assets/assets/fonts/IRANSansXFaNum-Black.ttf": "fcb1f01b71b36bd3ebfdc171885178ee",
"assets/assets/fonts/IRANSansXFaNum-Bold.ttf": "f3942a4d1852bd1e5c557c0d2f1c9e53",
"assets/assets/fonts/IRANSansXFaNum-Regular.ttf": "32e900508cd1f6220303f167f032df1f",
"assets/assets/fonts/IRANSansXFaNum-Thin.ttf": "fb961c97207cc8f7c409dbd503db56c7",
"assets/assets/fonts/IRANSansXFaNum-Bold.woff2": "7fc34dc50bf6a43deac2c139f3f2ce89",
"assets/assets/fonts/IRANSans.ttf": "860ad172ae5c052dea861911dc17b92a",
"assets/assets/fonts/IRANSansXFaNum-Medium.ttf": "e80730f952b42aea6adc1837bdef0318",
"assets/assets/fonts/IRANSansXFaNum-ExtraBold.ttf": "dbc0cdea551d7596e5b51b30e28ccb27",
"assets/assets/fonts/IRANSans_Light.ttf": "c808fbd805760a0863244d366b953df8",
"assets/assets/fonts/IRANSansXFaNum-UltraLight.ttf": "837c6e8d2ca480d68801eb2b44bfde9b",
"assets/assets/fonts/IRANSans_Black.ttf": "e54ac90b28d41bf268592f715c0bc04c",
"assets/assets/fonts/IRANSansXFaNum-Heavy.ttf": "6b8490d2227f69debce65f4be099e146",
"assets/assets/fonts/IRANSans_Medium.ttf": "e9b0ec6a034860115fe80d833c51e303",
"assets/assets/fonts/IRANSansXFaNum-ExtraBlack.ttf": "4762fcc0dfb21ee12cba68d9adbbd4fa",
"assets/assets/fonts/IRANSansXFaNum-DemiBold.ttf": "687f73e6d53611b6b7a491d01dd79b37",
"assets/assets/fonts/IRANSansXFaNum-Regular.woff2": "03623c37bec2d53253b3074c1e187f17",
"assets/assets/fonts/IRANSansXFaNum-Light.ttf": "eea0aa2a54b05f145f4d4534b4f0592b",
"assets/assets/fonts/IRANSans_UltraLight.ttf": "2ddb59ec93b6e61cda40f613e3dcaf5a",
"main.dart.js_2.part.js": "faa6d82a3dbf05ea0bc3489482a90bd0",
"sw.js": "fed485932d12c1b60edbf06e32263979",
"canvaskit/skwasm.js": "1ef3ea3a0fec4569e5d531da25f34095",
"canvaskit/skwasm_heavy.js": "413f5b2b2d9345f37de148e2544f584f",
"canvaskit/skwasm.js.symbols": "0088242d10d7e7d6d2649d1fe1bda7c1",
"canvaskit/canvaskit.js.symbols": "58832fbed59e00d2190aa295c4d70360",
"canvaskit/skwasm_heavy.js.symbols": "3c01ec03b5de6d62c34e17014d1decd3",
"canvaskit/skwasm.wasm": "264db41426307cfc7fa44b95a7772109",
"canvaskit/chromium/canvaskit.js.symbols": "193deaca1a1424049326d4a91ad1d88d",
"canvaskit/chromium/canvaskit.js": "5e27aae346eee469027c80af0751d53d",
"canvaskit/chromium/canvaskit.wasm": "24c77e750a7fa6d474198905249ff506",
"canvaskit/canvaskit.js": "140ccb7d34d0a55065fbd422b843add6",
"canvaskit/canvaskit.wasm": "07b9f5853202304d3b0749d9306573cc",
"canvaskit/skwasm_heavy.wasm": "8034ad26ba2485dab2fd49bdd786837b"};
// The application shell files that are downloaded before a service worker can
// start.
const CORE = ["main.dart.js",
"index.html",
"flutter_bootstrap.js",
"assets/AssetManifest.bin.json",
"assets/FontManifest.json"];

// During install, the TEMP cache is populated with the application shell files.
self.addEventListener("install", (event) => {
  self.skipWaiting();
  return event.waitUntil(
    caches.open(TEMP).then((cache) => {
      return cache.addAll(
        CORE.map((value) => new Request(value, {'cache': 'reload'})));
    })
  );
});
// During activate, the cache is populated with the temp files downloaded in
// install. If this service worker is upgrading from one with a saved
// MANIFEST, then use this to retain unchanged resource files.
self.addEventListener("activate", function(event) {
  return event.waitUntil(async function() {
    try {
      var contentCache = await caches.open(CACHE_NAME);
      var tempCache = await caches.open(TEMP);
      var manifestCache = await caches.open(MANIFEST);
      var manifest = await manifestCache.match('manifest');
      // When there is no prior manifest, clear the entire cache.
      if (!manifest) {
        await caches.delete(CACHE_NAME);
        contentCache = await caches.open(CACHE_NAME);
        for (var request of await tempCache.keys()) {
          var response = await tempCache.match(request);
          await contentCache.put(request, response);
        }
        await caches.delete(TEMP);
        // Save the manifest to make future upgrades efficient.
        await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
        // Claim client to enable caching on first launch
        self.clients.claim();
        return;
      }
      var oldManifest = await manifest.json();
      var origin = self.location.origin;
      for (var request of await contentCache.keys()) {
        var key = request.url.substring(origin.length + 1);
        if (key == "") {
          key = "/";
        }
        // If a resource from the old manifest is not in the new cache, or if
        // the MD5 sum has changed, delete it. Otherwise the resource is left
        // in the cache and can be reused by the new service worker.
        if (!RESOURCES[key] || RESOURCES[key] != oldManifest[key]) {
          await contentCache.delete(request);
        }
      }
      // Populate the cache with the app shell TEMP files, potentially overwriting
      // cache files preserved above.
      for (var request of await tempCache.keys()) {
        var response = await tempCache.match(request);
        await contentCache.put(request, response);
      }
      await caches.delete(TEMP);
      // Save the manifest to make future upgrades efficient.
      await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
      // Claim client to enable caching on first launch
      self.clients.claim();
      return;
    } catch (err) {
      // On an unhandled exception the state of the cache cannot be guaranteed.
      console.error('Failed to upgrade service worker: ' + err);
      await caches.delete(CACHE_NAME);
      await caches.delete(TEMP);
      await caches.delete(MANIFEST);
    }
  }());
});
// The fetch handler redirects requests for RESOURCE files to the service
// worker cache.
self.addEventListener("fetch", (event) => {
  if (event.request.method !== 'GET') {
    return;
  }
  var origin = self.location.origin;
  var key = event.request.url.substring(origin.length + 1);
  // Redirect URLs to the index.html
  if (key.indexOf('?v=') != -1) {
    key = key.split('?v=')[0];
  }
  if (event.request.url == origin || event.request.url.startsWith(origin + '/#') || key == '') {
    key = '/';
  }
  // If the URL is not the RESOURCE list then return to signal that the
  // browser should take over.
  if (!RESOURCES[key]) {
    return;
  }
  // If the URL is the index.html, perform an online-first request.
  if (key == '/') {
    return onlineFirst(event);
  }
  event.respondWith(caches.open(CACHE_NAME)
    .then((cache) =>  {
      return cache.match(event.request).then((response) => {
        // Either respond with the cached resource, or perform a fetch and
        // lazily populate the cache only if the resource was successfully fetched.
        return response || fetch(event.request).then((response) => {
          if (response && Boolean(response.ok)) {
            cache.put(event.request, response.clone());
          }
          return response;
        });
      })
    })
  );
});
self.addEventListener('message', (event) => {
  // SkipWaiting can be used to immediately activate a waiting service worker.
  // This will also require a page refresh triggered by the main worker.
  if (event.data === 'skipWaiting') {
    self.skipWaiting();
    return;
  }
  if (event.data === 'downloadOffline') {
    downloadOffline();
    return;
  }
});
// Download offline will check the RESOURCES for all files not in the cache
// and populate them.
async function downloadOffline() {
  var resources = [];
  var contentCache = await caches.open(CACHE_NAME);
  var currentContent = {};
  for (var request of await contentCache.keys()) {
    var key = request.url.substring(origin.length + 1);
    if (key == "") {
      key = "/";
    }
    currentContent[key] = true;
  }
  for (var resourceKey of Object.keys(RESOURCES)) {
    if (!currentContent[resourceKey]) {
      resources.push(resourceKey);
    }
  }
  return contentCache.addAll(resources);
}
// Attempt to download the resource online before falling back to
// the offline cache.
function onlineFirst(event) {
  return event.respondWith(
    fetch(event.request).then((response) => {
      return caches.open(CACHE_NAME).then((cache) => {
        cache.put(event.request, response.clone());
        return response;
      });
    }).catch((error) => {
      return caches.open(CACHE_NAME).then((cache) => {
        return cache.match(event.request).then((response) => {
          if (response != null) {
            return response;
          }
          throw error;
        });
      });
    })
  );
}
